#include <bits/stdc++.h>
 
using namespace std;
 
typedef long long ll;
typedef long double ld;
 
typedef vector<int> vi;
typedef vector<ll> vll;
 
typedef vector<vi> vvi;
typedef vector<vll> vvll;
 
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
 
typedef vector<pii> vpii;
typedef vector<pll> vpll;
 
typedef vector<vpii> vvpii;
typedef vector<vpll> vvpll;
 
#define pb push_back
#define mp make_pair
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define sz(x) (int)(x).size()
#define fi first
#define se second
 
template<class T> bool ckmin(T &a, const T &b) {return a > b ? a = b, 1 : 0;}
template<class T> bool ckmax(T &a, const T &b) {return a < b ? a = b, 1 : 0;}
 
namespace debug {
    void __print(int x) {cerr << x;}
    void __print(long long x) {cerr << x;}
    void __print(double x) {cerr << x;}
    void __print(long double x) {cerr << x;}
    void __print(char x) {cerr << '\'' << x << '\'';}
    void __print(const string &x) {cerr << '\"' << x << '\"';}
    void __print(const char *x) {cerr << '\"' << x << '\"';}
    void __print(bool x) {cerr << (x ? "true" : "false");}
 
    template<typename T, typename V>
    void __print(const pair<T, V> &x) {cerr << '{'; __print(x.first); cerr << ','; __print(x.second); cerr << '}';}
    template<typename T>
    void __print(const T &x) {int f = 0; cerr << '{'; for(auto z : x) cerr << (f++ ? "," : ""), __print(z); cerr << "}";}
    void _print() {cerr << "]\n";}
    template <typename T, typename... V>
    void _print(T t, V... v) {__print(t); if(sizeof...(v)) cerr << ", "; _print(v...);}
 
#ifdef ljuba
#define dbg(x...) cerr << "\e[91m" << "LINE(" << __LINE__ << ") -> " << "[" << #x << "] = ["; _print(x)
#else
#define dbg(x...)
#endif
}
 
using namespace debug;
 
const char nl = '\n';
 
mt19937 rng(chrono::high_resolution_clock::now().time_since_epoch().count());
 
/*
???????? ?????? ???????, ??? ???? ??? ????????????? (????? ???? ???????? ?????) 
?????? ?? ????????? ???? ????? ????????? ?? ??????, ????????? ??????? ? ???????
*/

const int mxN = 8e4 + 12;
vi adj[mxN];
int n, q;
int p[mxN];
int upit[mxN][4];

const int INF = 1e9 + 12;

class SegmentTree {
private:
    int n;
    vector<int> st;
public:
    SegmentTree(int _n) {
        n = 1;
        while(n < _n) n <<= 1;
        st.assign(2*n+1, -INF);
    }

    void update(int i, int x) {
        for(st[i += n] = x; i > 1; i >>= 1) {
            st[i>>1] = max(st[i], st[i^1]);
        }
    }

    int query(int l, int r) {
        int ans = -INF;
        for(l += n, r += n+1; l < r; l >>= 1, r >>= 1) {
            if(l&1) {
                ckmax(ans, st[l++]);
            }
            if(r&1) {
                ckmax(ans, st[--r]);
            }
        }
        return ans;
    }
};

void subtask1() {
    for(int iter = 0; iter < q; ++iter) {
        if(upit[iter][0] == 1) {
            int a = upit[iter][1];
            int b = upit[iter][2];
            swap(p[a], p[b]);
        } else {
            int l = upit[iter][1];
            int r = upit[iter][2];
            int x = upit[iter][3];
            queue<int> kju;
            vi dist(n, INF);
            dist[x] = 0;
            kju.push(x);
            while(!kju.empty()) {
                auto tren = kju.front();
                kju.pop();

                for(auto e : adj[tren]) {
                    if(ckmin(dist[e], dist[tren] + 1)) {
                        kju.push(e);
                    }
                }
            }

            //dbg(dist);

            int ans = -INF;

            for(int i = l; i <= r; ++i) {
                int tren = p[i];
                ckmax(ans, dist[tren]);
            }

            cout << ans << nl;
        }
    }
}

void subtask3() {
    queue<int> kju;
    vi dist(n, INF);
    dist[0] = 0;
    kju.push(0);

    while(!kju.empty()) {
        auto tren = kju.front();
        kju.pop();

        for(auto e : adj[tren]) {
            if(ckmin(dist[e], dist[tren] + 1)) {
                kju.push(e);
            }
        }
    }

    //dbg(dist);

    SegmentTree st(n);
    for(int i = 0; i < n; ++i) {
        st.update(i, dist[p[i]]);
    }

    for(int iter = 0; iter < q; ++iter) {
        if(upit[iter][0] == 1) {
            int a = upit[iter][1];
            int b = upit[iter][2];
            st.update(a, dist[p[b]]);
            st.update(b, dist[p[a]]);
            swap(p[a], p[b]);
        } else {
            int l = upit[iter][1];
            int r = upit[iter][2];
            cout << st.query(l, r) << nl;
        }
    }
}

void solve() {
    //n, q <= 4000 -> jednostavan brute force
    //kada je lanac -> napravis niz, nadjes najmanji i najveci indeks u tom nizu, ispises vecu razliku
    //kada je x = 1 -> uradis dfs od 1, napravis segmentno stablo nad dubinama cvorova, ispises najveci
    //nema dogadaja 1 -> podelis onaj niz na sqrt(N) blokova, za svaki blok belezis za svih n cvorova najvece rastojanje. Ako ne obuhvatis svaki u blok, samo za svaki uradis lca za rastojanje izmedju tog cvora i x

    cin >> n;
    for(int i = 0; i < n; ++i) {
        cin >> p[i];
        --p[i];
    }

    for(int i = 1; i < n; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        adj[u].pb(v);
        adj[v].pb(u);
    }

    cin >> q;
    for(int i = 0; i < q; ++i) {
        int t;
        cin >> t;
        if(t == 1) {
            int a, b;
            cin >> a >> b;
            --a, --b;
            upit[i][0] = t;
            upit[i][1] = a;
            upit[i][2] = b;
        } else {
            int l, r, x;
            cin >> l >> r >> x;
            --l, --r, --x;
            upit[i][0] = t;
            upit[i][1] = l;
            upit[i][2] = r;
            upit[i][3] = x;
        }
    }

    if(n <= 4000 && q <= 4000) {
        subtask1();
        return;
    }

    bool daLiJeSubtask3 = true;
    for(int i = 0; i < q; ++i) {
        if(upit[i][0] == 2) {
            daLiJeSubtask3 &= (upit[i][3] == 0);
        }
    }

    if(daLiJeSubtask3) {
        subtask3();
        return;
    }
}
 
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
 
    int testCases = 1;
    //cin >> testCases;
    while(testCases--)
        solve();
}